<xsl:stylesheet version="1.0"
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
     xmlns:msxsl="urn:schemas-microsoft-com:xslt"
     xmlns:user="urn:my-scripts"
     xmlns:const="urn:my-constants"
>

<xsl:output method="html" indent="yes" version="4.0"/>

<!-- ********************************************************************* -->
<!-- **************************  CONST  ********************************** -->
<!-- ******************************************************************** -->

<!-- pagesize enumeration -->
<const:DIALOG pagesize="kExtraSmall">203px</const:DIALOG>
<const:DIALOG pagesize="kSmall">305px</const:DIALOG>
<const:DIALOG pagesize="kMedium">373px</const:DIALOG>
<const:DIALOG pagesize="kLarge">388px</const:DIALOG>

<!-- valign enumeration -->
<const:CONTROL valign="kTop">top</const:CONTROL>
<const:CONTROL valign="kMiddle">middle</const:CONTROL>
<const:CONTROL valign="kBottom">bottom</const:CONTROL>

<!-- halign enumeration -->
<const:CONTROL halign="kLeft">left</const:CONTROL>
<const:CONTROL halign="kCenter">center</const:CONTROL>
<const:CONTROL halign="kRight">right</const:CONTROL>

<!-- Dialog Width -->
<const:DIALOG name="DialogWidth">516px</const:DIALOG>

<!-- prefix for help style names -->
<const:CONTROL name="prefix">ds_style</const:CONTROL>

<!-- postfix for graphic id graphic file names -->
<const:CONTROL name="graphicidpostfix">intv.gif</const:CONTROL>

<!-- default button graphics; for click version append "_click" to name (see clickImage()) -->
<const:CONTROL name="blueButtonBG">..\img\md_bkgrd_blu.gif</const:CONTROL>
<const:CONTROL name="blueButtonLeftSide">..\img\md_left_blu.gif</const:CONTROL>
<const:CONTROL name="blueButtonRightSide">..\img\md_right_blu.gif</const:CONTROL>
<const:CONTROL name="blueButtonLeftArrow">..\img\mdicn_arrowblu_left.gif</const:CONTROL>
<const:CONTROL name="blueButtonRightArrow">..\img\mdicn_arrowblu_right.gif</const:CONTROL>

<!-- Button Click and Double Click Dispatch JvaScript -->
<const:CONTROL name="BtnClick">ezdv_DispatchBtnClick</const:CONTROL>

<!-- ActiveX Control -->
<xsl:attribute-set name="ActiveX">
   <xsl:attribute name="classid">CLSID:7946085d-e2db-431d-926d-3db1ea3b1fbf</xsl:attribute>
</xsl:attribute-set>


<!-- DIALOG_MARGINS -->
<xsl:attribute-set name="DIALOG_MARGINS">
   <xsl:attribute name="style">PADDING-LEFT: 5px; PADDING-TOP: 8px</xsl:attribute>
</xsl:attribute-set>

<!-- SUPER BUTTONS -->
<xsl:attribute-set name="SUPER_BUTTON_BLUEBG_STYLE">
   <xsl:attribute name="style">
		margin:0px 0px 0px 0px;padding:0px;
		font-size:12px;
		font-family:Verdana;
		font-weight:bold;
		border:none;
		width:auto;
		overflow:hidden;
		background-repeat:repeat-x;
		vertical-align:middle;
		text-align:center;
		background-position:bottom;
		color:#ffffff;
		cursor:hand;
		background-image:url(../img/md_bkgrd_blu.gif);
	</xsl:attribute>
</xsl:attribute-set>

<!-- Left Margin -->
<xsl:attribute-set name="leftMargin">
   <xsl:attribute name="width">33px</xsl:attribute>
</xsl:attribute-set>

<!-- Dialog Area Margins -->
<xsl:attribute-set name="Vertical-Margins">
   <xsl:attribute name="style">padding-bottom: 16px;</xsl:attribute>
</xsl:attribute-set>

<!-- constant help style names -->
<xsl:attribute-set name="TitleStyle">
   <xsl:attribute name="class">ds_TitleStyle</xsl:attribute>
</xsl:attribute-set>
<xsl:attribute-set name="ButtonStyle">
   <xsl:attribute name="class">ds_ButtonStyle</xsl:attribute>
</xsl:attribute-set>
<xsl:attribute-set name="MainStyle">
   <xsl:attribute name="class">ds_MainStyle</xsl:attribute>
</xsl:attribute-set>
<xsl:attribute-set name="TextStyle">
   <xsl:attribute name="class">ds_TextStyle</xsl:attribute>
</xsl:attribute-set>
<xsl:attribute-set name="ValueStyle">
   <xsl:attribute name="class">ds_ValueStyle</xsl:attribute>
</xsl:attribute-set>
<xsl:attribute-set name="HyperStyle">
   <xsl:attribute name="class">ds_HyperStyle</xsl:attribute>
</xsl:attribute-set>

<!-- <table> object attributes -->
<xsl:attribute-set name="remove-table-padding">
   <xsl:attribute name="cellspacing">0</xsl:attribute>
   <xsl:attribute name="cellpadding">0</xsl:attribute>
   <xsl:attribute name="border">0</xsl:attribute>
</xsl:attribute-set>

<!-- ********************************************************************* -->
<!-- *******************  set attribute methods  ************************* -->
<!-- ********************************************************************* -->

<!-- ********************************************************************* -->
<xsl:template name="set_class">
   <xsl:choose>
      <xsl:when test="@styletype='kName' or @styletype='kIndex'">
         <xsl:attribute name="class">
            <!-- concat class name prefix with $style -->
            <xsl:value-of select="document('')/xsl:stylesheet/const:CONTROL[@name='prefix']"/>
            <xsl:value-of select="@style"/>
         </xsl:attribute>
      </xsl:when>
      <xsl:when test="@styletype='kClass'">
         <xsl:attribute name="class">
            <!-- use style name straight out of attribute -->
            <xsl:value-of select="@style"/>
         </xsl:attribute>
      </xsl:when>
      <xsl:when test="@styletype='kCSS'">
         <xsl:attribute name="style">
            <xsl:value-of select="@style"/>
         </xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
         <xsl:attribute name="class">
            <!-- concat class name prefix with $style -->
            <xsl:value-of select="document('')/xsl:stylesheet/const:CONTROL[@name='prefix']"/>
            <xsl:value-of select="@style"/>
         </xsl:attribute>
      </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template name="set_rowcolspan">
   <xsl:param name="colspan" select="@colspan"/>
   <xsl:param name="rowspan" select="@rowspan"/>
   <xsl:if test="$colspan">
      <xsl:attribute name="colspan">
         <xsl:value-of select="$colspan"/>
      </xsl:attribute>
   </xsl:if>
   <xsl:if test="$rowspan">
      <xsl:attribute name="rowspan">
         <xsl:value-of select="$rowspan"/>
      </xsl:attribute>
   </xsl:if>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template name="set_alignment">
   <xsl:param name="valign" select="@valign"/>
   <xsl:param name="halign" select="@halign"/>
   <xsl:if test="@valign">
      <xsl:attribute name="valign">
         <xsl:value-of select="document('')/xsl:stylesheet/const:CONTROL[@valign=$valign]"/>
      </xsl:attribute>
   </xsl:if>
   <xsl:if test="@halign">
      <xsl:attribute name="align">
         <xsl:value-of select="document('')/xsl:stylesheet/const:CONTROL[@halign=$halign]"/>
      </xsl:attribute>
   </xsl:if>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template name="set_onclick">
   <xsl:param name="tag"/>
   <xsl:param name="attr"/>
   <xsl:param name="js"/>
   <xsl:param name="triggerID"><xsl:value-of select="@id"/></xsl:param>
   <xsl:param name="triggerGroupID"><xsl:value-of select="@groupid"/></xsl:param>
   <xsl:param name="triggers">
      <xsl:if test="$triggerID!=''">
         <xsl:apply-templates select="/xmlDIALOG/DIALOG//TRIGGER[@source=$triggerID]" mode="onchange"/>
      </xsl:if>
      <xsl:if test="$triggerGroupID!=''">
         <xsl:apply-templates select="/xmlDIALOG/DIALOG//TRIGGER[@source=$triggerGroupID]" mode="onchange"/>
      </xsl:if>
   </xsl:param>
   <xsl:attribute name="onclick">
      <xsl:value-of select="$js"/>
      <xsl:call-template name="create_eventDataBinding"/>      
      <xsl:value-of select="document('')/xsl:stylesheet/const:CONTROL[@name='BtnClick']"/>
      <xsl:text>('event%=%onclick%:%tag%=%</xsl:text>
      <xsl:value-of select="$tag"/>
      <xsl:text>%:%</xsl:text>
      <xsl:value-of select="$attr"/>
      <xsl:text>');</xsl:text>
      <xsl:value-of select="$triggers"/>
   </xsl:attribute>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template name="set_onchange">
   <xsl:param name="tag"/>
   <xsl:param name="attr"/>
   <xsl:param name="js"/>
   <xsl:param name="triggerID"><xsl:value-of select="@id"/></xsl:param>
   <xsl:param name="triggers">
      <xsl:if test="$triggerID">
         <xsl:apply-templates select="/xmlDIALOG/DIALOG//TRIGGER[@source=$triggerID]" mode="onchange"/>
      </xsl:if>
   </xsl:param>
   <xsl:attribute name="onchange">
      <xsl:value-of select="$js"/>
      <xsl:call-template name="create_eventDataBinding"/>      
      <xsl:value-of select="document('')/xsl:stylesheet/const:CONTROL[@name='BtnClick']"/>
      <xsl:text>('event%=%onclick%:%tag%=%</xsl:text>
      <xsl:value-of select="$tag"/>
      <xsl:text>%:%</xsl:text>
      <xsl:value-of select="$attr"/>
      <xsl:text>');</xsl:text>
      <xsl:value-of select="$triggers"/>
   </xsl:attribute>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template name="set_ondblclick">
   <xsl:param name="tag"/>
   <xsl:param name="attr"/>
   <xsl:param name="js"/>
   <xsl:attribute name="ondblclick">
      <xsl:value-of select="$js"/>
      <xsl:value-of select="document('')/xsl:stylesheet/const:CONTROL[@name='BtnClick']"/>
      <xsl:text>('event%=%ondblclick%:%tag%=%</xsl:text>
      <xsl:value-of select="$tag"/>
      <xsl:text>%:%</xsl:text>
      <xsl:value-of select="$attr"/>
      <xsl:text>');</xsl:text>
   </xsl:attribute>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template name="set_id">
   <xsl:if test="@id">
      <xsl:attribute name="id">
         <xsl:value-of select="@id"/>
      </xsl:attribute>
   </xsl:if>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template name="set_tabIndex">
   <xsl:attribute name="tabIndex">
      <xsl:choose>
         <xsl:when test="@tabIndex">
            <xsl:value-of select="@tabIndex"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>10000</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:attribute>
</xsl:template>   


<!-- ********************************************************************* -->
<xsl:template name="set_checked">
   <xsl:if test="@checked">
      <xsl:attribute name="checked">
         <xsl:value-of select="@checked"/>
      </xsl:attribute>
   </xsl:if>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template name="set_selected">
   <xsl:if test="@selected">
      <xsl:attribute name="selected">
         <xsl:value-of select="@selected"/>
      </xsl:attribute>
   </xsl:if>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template name="set_width">
   <xsl:if test="@width">
      <xsl:attribute name="width">
         <xsl:value-of select="@width"/>
      </xsl:attribute>
   </xsl:if>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template name="set_widthbystyle">
   <xsl:param name="default"/>
   <xsl:if test="@width">
      <xsl:attribute name="style">
         <xsl:text>width:</xsl:text>
         <xsl:value-of select="@width"/>
         <xsl:text>%;</xsl:text>
      </xsl:attribute>
   </xsl:if>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template name="set_height">
   <xsl:if test="@height">
      <xsl:attribute name="height">
         <xsl:value-of select="@height"/>
      </xsl:attribute>
   </xsl:if>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template name="set_heightbysize">
   <xsl:if test="@height">
      <xsl:attribute name="size">
         <xsl:value-of select="@height"/>
      </xsl:attribute>
   </xsl:if>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template name="set_default">
   <xsl:if test="@default">
      <xsl:text>%%%ezdv_setFocusItem('</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>')%%%</xsl:text>
   </xsl:if>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template name="set_hover">
   <xsl:param name="imageid"/>
   <xsl:attribute name="onmouseover">
      <xsl:text>imgHover('</xsl:text>
      <xsl:value-of select="$imageid"/>
      <xsl:text>');</xsl:text>
   </xsl:attribute>
   <xsl:attribute name="onmouseout">
      <xsl:text>imgNormal('</xsl:text>
      <xsl:value-of select="$imageid"/>
      <xsl:text>');</xsl:text>
   </xsl:attribute>
   <xsl:attribute name="onmousedown">
      <xsl:text>imgDown('</xsl:text>
      <xsl:value-of select="$imageid"/>
      <xsl:text>');</xsl:text>
   </xsl:attribute>   
   <xsl:attribute name="onmouseup">
      <xsl:text>imgHover('</xsl:text>
      <xsl:value-of select="$imageid"/>
      <xsl:text>');</xsl:text>
   </xsl:attribute>
</xsl:template>

<!-- ********************************************************************* -->
<!-- **************************  create methods  ************************* -->
<!-- ********************************************************************* -->

<!-- ********************************************************************* -->
<xsl:template name="create_list">
   <xsl:attribute name="type">
      <xsl:value-of select="@type"/>
   </xsl:attribute>
   <xsl:if test="@start">
      <xsl:attribute name="start">
         <xsl:value-of select="@start"/>
      </xsl:attribute>
   </xsl:if>
   <xsl:if test="@graphictype">
      <xsl:attribute name="style">
         <xsl:text>list-style-image:url(</xsl:text>
         <xsl:value-of select="@graphic"/>
         <xsl:if test="@graphictype='kGraphicID'">
            <xsl:value-of select="document('')/xsl:stylesheet/const:CONTROL[@name='graphicidpostfix']"/>
         </xsl:if>
         <xsl:text>);</xsl:text>
      </xsl:attribute>
   </xsl:if>
   <xsl:apply-templates />
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template name="create_orderedlist">
   <ol>
      <xsl:call-template name="create_list"/>
   </ol>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template name="create_unorderedlist">
   <ul>
      <xsl:call-template name="create_list"/>
   </ul>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template name="create_image">
   <!-- paramters that must be passed in -->
   <!-- img tag must have been opened by caller -->
   <xsl:param name="graphictype"/>
   <xsl:param name="graphic" select="@graphic"/>
   <xsl:param name="width"/>
   <xsl:param name="height"/>
   <xsl:param name="hoverid"/>
   
   <!-- local variable -->
   <xsl:param name="src">
      <xsl:value-of select="$graphic"/>
      <xsl:if test="$graphictype='kGraphicID'">
         <xsl:value-of select="document('')/xsl:stylesheet/const:CONTROL[@name='graphicidpostfix']"/>
      </xsl:if>
   </xsl:param>
   <xsl:choose>
      <xsl:when test="$hoverid">
         <xsl:attribute name="src">
            <xsl:value-of select="user:normalImage(string($src))"/>
         </xsl:attribute>
         <xsl:attribute name="id">
            <xsl:value-of select="$hoverid"/>
         </xsl:attribute>
         <xsl:call-template name="set_hover">
            <xsl:with-param name="imageid" select="$hoverid"/>
         </xsl:call-template>
         <xsl:attribute name="hoverSrc">
            <xsl:value-of select="user:hoverImage(string($src))"/>
         </xsl:attribute>
         <xsl:attribute name="normalSrc">
            <xsl:value-of select="user:normalImage(string($src))"/>
         </xsl:attribute>
         <xsl:attribute name="downSrc">
            <xsl:value-of select="user:downImage(string($src))"/>
         </xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
         <xsl:attribute name="src">
            <xsl:value-of select="$src"/>
         </xsl:attribute>
      </xsl:otherwise>
   </xsl:choose>
   <xsl:if test="$width">
      <xsl:attribute name="width">
         <xsl:value-of select="$width"/>
      </xsl:attribute>
   </xsl:if>
   <xsl:if test="$height">
      <xsl:attribute name="height">
         <xsl:value-of select="$height"/>
      </xsl:attribute>
   </xsl:if>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template name="create_superbuttonimage">
   <!-- paramters that must be passed in -->
   <!-- img tag must have been opened by caller -->
   <xsl:param name="graphic"/>
   
   <xsl:attribute name="src">
      <xsl:value-of select="$graphic"/>
   </xsl:attribute>
   <xsl:attribute name="normalSrc">
      <xsl:value-of select="$graphic"/>
   </xsl:attribute>
   <xsl:attribute name="clickSrc">
      <xsl:value-of select="user:clickImage(string($graphic))"/>
   </xsl:attribute>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template name="create_button">
   <!-- passed when creating Back Button from match="FOOTER" template -->   
   <xsl:param name="id" select="@id"/>
   <xsl:param name="buttonText"/> 
   <xsl:param name="width"/>
   <xsl:param name="tag">
      <xsl:text>BUTTON</xsl:text>
   </xsl:param>
   <xsl:param name="attr">
      <xsl:text>id%=%</xsl:text>
      <xsl:value-of select="$id"/>
   </xsl:param>
   <xsl:param name="defaultGraphicID">
      <xsl:value-of select="$id"/>
   </xsl:param>
   <xsl:param name="mode"/>
   
   <!-- build arrow (used to be blue dot) image -->
   <xsl:if test="not(@graphictype)">
		<td valign="top">
		<!-- test for IF conditional around footer button, and handle specially -->
      <xsl:if test="$mode='footer'">
         <xsl:if test="parent::IF">
            <xsl:call-template name="set_condition">
               <xsl:with-param name="condition">
                  <xsl:value-of select="../@condition"/>
               </xsl:with-param>
               <xsl:with-param name="nameValuePairs">
                  <xsl:apply-templates select="../PARAM" mode="dynamic"/>
                  <xsl:apply-templates select="../BIND" mode="dataBinding"/>
               </xsl:with-param>
               <xsl:with-param name="id">
                  <xsl:value-of select="../@id"/>
               </xsl:with-param>
            </xsl:call-template>
         </xsl:if>
      </xsl:if>
		<span onkeyup="ezdv_accelarator(this)" style="cursor:hand;">
			<xsl:attribute name="id">
				<xsl:value-of select="$defaultGraphicID"/>
			</xsl:attribute>    
			<xsl:call-template name="set_tabIndex"/>
			<xsl:call-template name="set_onclick">
				<xsl:with-param name="tag" select="$tag"/>
				<xsl:with-param name="attr" select="$attr"/>
			</xsl:call-template>
			<xsl:call-template name="set_default"/>
		
		<table cellpadding="0px" cellspacing="0px" style="margin-right:2px;">
			<xsl:attribute name="onmousedown">
               <xsl:text>ezdv_SuperButtonMouseDown(this);</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="onmouseup">
               <xsl:text>ezdv_SuperButtonMouseUp(this);</xsl:text>
            </xsl:attribute>
            <xsl:attribute name="onmouseout">
               <xsl:text>ezdv_SuperButtonMouseUp(this);</xsl:text>
            </xsl:attribute> 
			<tr style="margin:0px;padding:0px;border:none; vertical-align:middle">
			
			<td>
				<img style="vertical-align:bottom;">
				<xsl:call-template name="create_superbuttonimage">
					<xsl:with-param name="graphic" select="document('')/xsl:stylesheet/const:CONTROL[@name='blueButtonLeftSide']/text()"/>
				</xsl:call-template>
				</img>
			</td>
				
			<!-- Do the left arrow if specified -->
			<xsl:if test="$mode='back'">
				<td>
				<img style="vertical-align:bottom;">
			      <xsl:call-template name="create_superbuttonimage">
   			      <xsl:with-param name="graphic" select="document('')/xsl:stylesheet/const:CONTROL[@name='blueButtonLeftArrow']/text()"/>
			      </xsl:call-template>
				</img>
				</td>
			</xsl:if>
			
			<!-- Do the middle with background and text -->
			<td xsl:use-attribute-sets="SUPER_BUTTON_BLUEBG_STYLE">
				<xsl:attribute name="normalBkg">
					<xsl:value-of select="document('')/xsl:stylesheet/const:CONTROL[@name='blueButtonBG']/text()"/>
				</xsl:attribute>	
				<xsl:attribute name="clickBkg">
					<xsl:value-of select="user:clickImage(string(document('')/xsl:stylesheet/const:CONTROL[@name='blueButtonBG']/text()))"/>
				</xsl:attribute>
				<xsl:if test="$buttonText">
					<xsl:value-of select="$buttonText"/>
				</xsl:if>
				<xsl:if test="not($buttonText)">
					<xsl:apply-templates />
				</xsl:if>
			</td>
			
			<!-- Do the right arrow if specified -->
         <xsl:if test="$mode='footer'">
            <td>
				<img style="vertical-align:bottom;">
			      <xsl:call-template name="create_superbuttonimage">
   			      <xsl:with-param name="graphic" select="document('')/xsl:stylesheet/const:CONTROL[@name='blueButtonRightArrow']/text()"/>
			      </xsl:call-template>
				</img>
			</td>
		</xsl:if>
				
			<!-- Do the right side with just an image -->
			<td>
			<img style="vertical-align:bottom;">
			   <xsl:call-template name="create_superbuttonimage">
			      <xsl:with-param name="graphic" select="document('')/xsl:stylesheet/const:CONTROL[@name='blueButtonRightSide']/text()"/>
			   </xsl:call-template>
			</img>
			</td></tr></table></span>
		</td>

   </xsl:if>
   <xsl:if test="@graphictype">
  		<!-- No need to test for IF conditinal becuase graphic buttons are not allowed in footer -->
      <img border="0" style="cursor: hand;" onkeyup="ezdv_accelarator(this)">
         <xsl:attribute name="id">
            <xsl:value-of select="$defaultGraphicID"/>
         </xsl:attribute>
         <xsl:call-template name="set_onclick">
            <xsl:with-param name="tag" select="$tag"/>
            <xsl:with-param name="attr" select="$attr"/>
         </xsl:call-template>
         <xsl:call-template name="create_image">
            <xsl:with-param name="graphictype" select="@graphictype"/>
            <xsl:with-param name="graphic" select="@graphic"/>
            <xsl:with-param name="width" select="@graphicwidth"/>
            <xsl:with-param name="height" select="@graphicheight"/>
            <xsl:with-param name="hoverid" select="$defaultGraphicID"/>
         </xsl:call-template>
         <xsl:call-template name="set_hover">
            <xsl:with-param name="imageid" select="$defaultGraphicID"/>
         </xsl:call-template>
      </img>
   </xsl:if>

</xsl:template>

<!-- ********************************************************************* -->
<!-- create_object; called from various control to created embedded ActiveX control -->
<xsl:template name="create_object">
   <xsl:param name="createTag"/>
   <xsl:param name="width"/>
   <xsl:param name="height"/>
   <object xsl:use-attribute-sets="ActiveX">
      <xsl:attribute name="name">
         <xsl:value-of select="$createTag"/>
      </xsl:attribute>
      <xsl:attribute name="style">
         <xsl:if test="$width">
            <xsl:text>width:</xsl:text>
            <xsl:value-of select="$width"/>
            <xsl:text>;</xsl:text>
         </xsl:if>
         <xsl:if test="$height">
            <xsl:text>height:</xsl:text>
            <xsl:value-of select="$height"/>
            <xsl:text>;</xsl:text>
         </xsl:if>
      </xsl:attribute>
      <xsl:call-template name="set_default"/>
   </object>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template name="create_eventDataBinding">
   <xsl:if test="@event">
      <xsl:value-of select="document('')/xsl:stylesheet/const:CONTROL[@name='BtnClick']"/>
      <xsl:text>('event%=%</xsl:text>
      <xsl:value-of select="@event"/>
      <xsl:text>%:%</xsl:text>
      <xsl:apply-templates select="BIND" mode="dataBinding"/>
      <xsl:text>');</xsl:text>
   </xsl:if>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template name="set_condition">
   <xsl:param name="condition"/>
   <xsl:param name="nameValuePairs"/>
   <xsl:param name="id"/>
   <xsl:if test="$condition!=''">
      <xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
      <xsl:attribute name="ezdvCondition"><xsl:value-of select="user:tweakEval(string($condition),string($nameValuePairs))"/></xsl:attribute>
      <xsl:attribute name="style">%%%((<xsl:value-of select="user:tweakEval(string($condition),string($nameValuePairs))" />)?'':'display:none;')%%%</xsl:attribute>
   </xsl:if>
</xsl:template>

<!-- ********************************************************************* -->
<!-- **************************  MAIN   ********************************** -->
<!-- ********************************************************************* -->
<xsl:template match="/">
    <xsl:apply-templates />
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="DIALOG">
   <xsl:param name="pagesize" select="@pagesize"/>
   <div xsl:use-attribute-sets="DIALOG_MARGINS">
   <table xsl:use-attribute-sets="remove-table-padding">
   <xsl:attribute name="style">
      <xsl:if test="document('')/xsl:stylesheet/const:DIALOG[@pagesize=$pagesize]">
         <xsl:text>height:</xsl:text>
         <xsl:value-of select="document('')/xsl:stylesheet/const:DIALOG[@pagesize=$pagesize]"/>
         <xsl:text>;</xsl:text>
      </xsl:if>
      <xsl:text>width:</xsl:text>
      <xsl:value-of select="document('')/xsl:stylesheet/const:DIALOG[@name='DialogWidth']"/>
   </xsl:attribute>
   <xsl:apply-templates />
   </table>
   </div>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="TITLE">
   <xsl:comment>TITLE</xsl:comment>
   <tr valign="top" xsl:use-attribute-sets="Vertical-Margins">
   <td colspan="2" height="1">
   <div>
   <table width="100%" xsl:use-attribute-sets="remove-table-padding">
   <tr valign="top"><td align="left" xsl:use-attribute-sets="TitleStyle">
   <xsl:apply-templates/>
   </td></tr></table>
   </div></td></tr>
</xsl:template>               

<!-- ********************************************************************* -->
<xsl:template match="BODY">
   <xsl:comment>BODY</xsl:comment>
   <tr valign="top" height="1">
   <td height="1" xsl:use-attribute-sets="leftMargin"/>
   <td>
   <xsl:apply-templates/>
   </td>
   </tr>
</xsl:template>               

<!-- ********************************************************************* -->
<xsl:template match="FOOTER">
   <xsl:param name="backid">
      <xsl:choose>
		<!-- if there is a back id, use it..if not use kEPRC_Back -->
         <xsl:when test="@backid">
            <xsl:value-of select="@backid"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>kEPRC_Back</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:param>
   <xsl:comment>FOOTER</xsl:comment>
   <tr valign="bottom" height="100%" xsl:use-attribute-sets="Vertical-Margins">
      <td colspan="2">
         <table width="100%" xsl:use-attribute-sets="remove-table-padding">
            <tr valign="bottom" height="100%">
               <xsl:call-template name="create_button">
                  <xsl:with-param name="id" select="$backid"/>
                  <xsl:with-param name="buttonText" select="'Back'"/>
                  <xsl:with-param name="mode">back</xsl:with-param>
               </xsl:call-template>
               <td valign="top" align="right">
				<table xsl:use-attribute-sets="remove-table-padding">
					<tr valign="bottom" height="100%">
						<xsl:apply-templates mode="footer"/>
					</tr>
				</table>
               </td>
            </tr>
         </table>
      </td>
   </tr>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="GRID">
   <table xsl:use-attribute-sets="remove-table-padding">
   <xsl:call-template name="set_width"/>
   <xsl:apply-templates />
   </table>
</xsl:template>               

<!-- ********************************************************************* -->
<xsl:template match="ROW">
   <tr>
   <xsl:call-template name="set_height"/>
   <xsl:apply-templates />
   </tr>
</xsl:template>               

<!-- ********************************************************************* -->
<xsl:template match="COL">
   <td>
   <xsl:call-template name="set_width"/>
   <xsl:call-template name="set_alignment"/>
   <xsl:call-template name="set_rowcolspan"/>
   <xsl:apply-templates />
   </td>
</xsl:template>               

<!-- ********************************************************************* -->
<xsl:template match="TEXT|STYLE">
   <span>
   <xsl:call-template name="set_id"/>
   <xsl:call-template name="set_class"/>
   <xsl:call-template name="set_width"/>
   <xsl:apply-templates />
   </span>
</xsl:template>                     

<!-- ********************************************************************* -->
<xsl:template match="P">
   <P>
   <xsl:apply-templates />
   </P>
</xsl:template>               

<!-- ********************************************************************* -->
<xsl:template match="HYPER">
   <xsl:param name="tag">
      <xsl:text>HYPER</xsl:text>
   </xsl:param>
   <xsl:param name="attr">
      <xsl:text>type%=%</xsl:text>
      <xsl:value-of select="@type"/>
      <xsl:text>%:%addr%=%</xsl:text>
      <xsl:value-of select="@addr"/>
   </xsl:param>
   <xsl:param name="triggerID">
      <xsl:if test="@type='kButton'">
         <xsl:value-of select="@addr"/>
      </xsl:if>
   </xsl:param>
   <span style="color:blue;text-decoration: underline;cursor: hand;" onkeyup="ezdv_accelarator(this)">
      <xsl:call-template name="set_tabIndex"/>
      <xsl:call-template name="set_onclick">
         <xsl:with-param name="tag" select="$tag"/>
         <xsl:with-param name="attr" select="$attr"/>
         <xsl:with-param name="triggerID" select="$triggerID"/>
      </xsl:call-template>
      <xsl:apply-templates />
   </span>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="LIST">
   <xsl:param name="type" select="@type"/>
   <xsl:choose>
      <xsl:when test="$type='1' or $type='a' or $type='A' or $type='i' or $type='I'">
         <xsl:call-template name="create_orderedlist"/>
      </xsl:when>
      <xsl:otherwise>
         <xsl:call-template name="create_unorderedlist"/>
      </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="LISTITEM">
   <li>
   <xsl:if test="@style">
      <xsl:attribute name="style">
         <xsl:value-of select="@style"/>
      </xsl:attribute>
   </xsl:if>
   <xsl:apply-templates />
   </li>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="TOOLTIP">
   <xsl:apply-templates />
</xsl:template>

<!-- ********************************************************************* -->
<!-- SPACER control, creates horizontal and vertical space -->
<xsl:template match="SPACER">
   <img src="..\img\clear.gif">
   <xsl:attribute name="style">
      <xsl:text>height:1em;</xsl:text>
      <xsl:if test="@width">
         <xsl:text>width:</xsl:text>
         <xsl:value-of select="(5.16)*@width"/> <!-- assuming dialog width of 516 pixels -->
         <xsl:text>px;</xsl:text>
      </xsl:if>
   </xsl:attribute>
   <xsl:apply-templates />
   </img>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="MOVIE">
   <xsl:param name="movie">
      <xsl:text>tag%=%MOVIE%:%movie%=%</xsl:text>
      <xsl:value-of select="@movie"/>
   </xsl:param>
   <xsl:call-template name="create_object">
      <xsl:with-param name="createTag" select="$movie"/>
      <xsl:with-param name="width" select="@width"/>
      <xsl:with-param name="height" select="@height"/>
   </xsl:call-template>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="GRAPHIC">
   <img>
   <xsl:call-template name="create_image">
      <xsl:with-param name="graphictype" select="@type"/>
      <xsl:with-param name="graphic" select="@graphic"/>
      <xsl:with-param name="width" select="@width"/>
      <xsl:with-param name="height" select="@height"/>
   </xsl:call-template>
   <xsl:call-template name="set_alignment"/>
   </img>
</xsl:template>

<!-- ********************************************************************* -->
<!-- create a BUTTON in the BODY tag area -->
<xsl:template match="BUTTON">
   <table xsl:use-attribute-sets="remove-table-padding">
   <xsl:if test="@width">
      <xsl:attribute name="width">
         <xsl:value-of select="@width"/>
         <xsl:text>%</xsl:text>
      </xsl:attribute>
   </xsl:if>
   <xsl:call-template name="create_button"/>
   </table>
</xsl:template>

<!-- ********************************************************************* -->
<!-- create a BUTTON in the FOOTER tag area -->
<xsl:template match="BUTTON" mode="footer">
   <xsl:comment>BUTTON</xsl:comment>
   <xsl:call-template name="create_button">
      <xsl:with-param name="width">
         <xsl:if test="@width">
            <xsl:value-of select="@width"/>
         </xsl:if>
         <xsl:if test="not(@width)">
            <xsl:text>20</xsl:text>
         </xsl:if>
      </xsl:with-param>
      <xsl:with-param name="mode">footer</xsl:with-param>
   </xsl:call-template>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="CHECKBOX">
  <span>
    <xsl:call-template name="set_widthbystyle"/>
    <input type="checkbox">
      <xsl:attribute name="ezdvValue">
        <xsl:value-of select="@value"/>
      </xsl:attribute>
      <xsl:call-template name="set_tabIndex"/>
      <xsl:call-template name="set_onclick">
        <xsl:with-param name="tag">
          <xsl:text>CHECKBOX</xsl:text>
        </xsl:with-param>
        <xsl:with-param name="attr">
          <xsl:text>id%=%</xsl:text>
          <xsl:value-of select="@id"/>
          <xsl:text>%:%element%=%</xsl:text>
          <xsl:value-of select="@element"/>
        </xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="set_id"/>
      <xsl:call-template name="set_checked"/>
      <xsl:call-template name="set_default"/>

      <!-- wrap in label tag to catch click events and route them -->
      <!-- to the checkbox                                        -->
      <label>
        <xsl:if test="@id">
          <xsl:attribute name="for">
            <xsl:value-of select="@id"/>
          </xsl:attribute>
        </xsl:if>
        <!-- if checkbox text is to have a fixed margin (2nd+ lines wrap to be under the checkbox, -->
        <!-- set the margin to 'fixed' to float as a text box that's moved up and to the right of the checkbox -->
        <!-- and will have all text lines have a fixed margin -->
        <!-- the top positioning of -18px isn't the best solution...-1em wasn't perfect and this is really font-size dependent -->
        <xsl:if test="@margin='fixed'">
          <xsl:attribute name="style">
            <xsl:text>float:left; position:relative; top:-18px; left:22px;</xsl:text>
          </xsl:attribute>
        </xsl:if>
        <xsl:apply-templates />
      </label>
    </input>
  </span>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="RADIO">
   <span>
   <xsl:call-template name="set_widthbystyle"/>
   <input type="radio">
      <xsl:attribute name="ezdvValue">
         <xsl:value-of select="@value"/>
      </xsl:attribute>
      <xsl:call-template name="set_tabIndex"/>
      <xsl:call-template name="set_onclick">
      <xsl:with-param name="tag">
         <xsl:text>RADIO</xsl:text>
      </xsl:with-param>
      <xsl:with-param name="attr">
         <xsl:text>id%=%</xsl:text>
         <xsl:value-of select="@id"/>
         <xsl:text>%:%element%=%</xsl:text>
         <xsl:value-of select="@element"/>
         <xsl:text>%:%groupid%=%</xsl:text>
         <xsl:value-of select="@groupid"/>
      </xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="set_id"/>
   <xsl:attribute name="name">
      <xsl:value-of select="@groupid"/>
   </xsl:attribute>
   <xsl:call-template name="set_checked"/>
   <xsl:call-template name="set_default"/>

   <!-- wrap in label tag to catch click events and route them -->
   <!-- to the checkbox                                        -->
   <label>
   <xsl:if test="@id">
      <xsl:attribute name="for">
         <xsl:value-of select="@id"/>
      </xsl:attribute>
   </xsl:if>
   <xsl:apply-templates />
   </label>
   </input>
   </span>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="EDIT">
   <input type="text">
      <xsl:call-template name="set_id"/>
      <xsl:call-template name="set_tabIndex"/>
      <xsl:call-template name="set_default"/>            
      <xsl:attribute name="type">
         <xsl:choose>
            <xsl:when test="@password">
               <xsl:text>password</xsl:text>
            </xsl:when>
            <xsl:otherwise>
               <xsl:text>text</xsl:text>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:attribute>
      <xsl:attribute name="size">
         <xsl:value-of select="@width"/>
      </xsl:attribute>
      <xsl:attribute name="value">
         <xsl:value-of select="@value"/>
      </xsl:attribute>
      <xsl:attribute name="maxlen">
         <xsl:value-of select="@maxlen"/>
      </xsl:attribute>
   </input>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="EDITMULTILINE">
  <textarea>
    <xsl:call-template name="set_id"/>
    <xsl:call-template name="set_tabIndex"/>
    <xsl:call-template name="set_default"/>     
    <xsl:attribute name="rows">
      <xsl:value-of select="@height"/>
    </xsl:attribute>
    <xsl:attribute name="cols">
      <xsl:value-of select="@width"/>
    </xsl:attribute>
    <xsl:attribute name="maxlen">
      <xsl:value-of select="@maxlen"/>
    </xsl:attribute>
  </textarea>
</xsl:template>
  
<!-- ********************************************************************* -->
<xsl:template match="LISTBOX">
   <xsl:param name="tag">
      <xsl:text>LISTBOX</xsl:text>
   </xsl:param>
   <xsl:param name="attr">
      <xsl:text>id%=%</xsl:text>
      <xsl:value-of select="@id"/>
   </xsl:param>
   <select xsl:use-attribute-set="ValueStyle">
   <xsl:call-template name="set_onchange">
      <xsl:with-param name="tag" select="$tag"/>
      <xsl:with-param name="attr" select="$attr"/>
   </xsl:call-template>
   <xsl:call-template name="set_ondblclick">
      <xsl:with-param name="tag" select="$tag"/>
      <xsl:with-param name="attr" select="$attr"/>
   </xsl:call-template>
   <xsl:call-template name="set_id"/>
   <xsl:call-template name="set_heightbysize"/>
   <xsl:if test="@width">
      <xsl:attribute name="style">
         <xsl:text>width:</xsl:text>
         <xsl:value-of select="@width"/>
         <xsl:text>px;</xsl:text>
      </xsl:attribute>
   </xsl:if>
   <xsl:call-template name="set_default"/>
   <xsl:apply-templates />
   </select>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="LISTROW">
   <option>
   <xsl:call-template name="set_id"/>
   <xsl:if test="@value">
      <xsl:attribute name="value">
         <xsl:value-of select="@value"/>
      </xsl:attribute>
   </xsl:if>
   <xsl:call-template name="set_selected"/>
   <xsl:apply-templates />
   </option>
</xsl:template>

<!-- ********************************************************************* -->
<!-- embedded ActiveX control -->
<xsl:template match="CONTROL">
   <xsl:call-template name="create_object">
      <xsl:with-param name="createTag">
         <xsl:text>tag%=%CONTROL%:%name%=%</xsl:text>
         <xsl:value-of select="@name"/>
      </xsl:with-param>
      <xsl:with-param name="width" select="@width"/>
      <xsl:with-param name="height" select="@height"/>
   </xsl:call-template>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="LINEBREAK">
   <br>
   <xsl:apply-templates />
   </br>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="PARAM">
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="PARAM" mode="dynamic">
   <xsl:value-of select="@name"/>
   <xsl:text>%=%</xsl:text>
   <xsl:apply-templates />
   <xsl:text>%:%</xsl:text>
</xsl:template>

<!-- ********************************************************************* 
    DYNAMIC tag without an id will add spaces to the output which will render
    in html with 1 space before and after the valu
    use attribute whitespace="none" to remove whitespace
    With an id also adds whitespace...update if needed
    -->
<xsl:template match="DYNAMIC">
  <xsl:param name="nameValuePairs">
    <xsl:apply-templates select="PARAM" mode="dynamic"/>
    <xsl:apply-templates select="BIND" mode="dataBinding"/>
  </xsl:param>
  <xsl:if test="@id">
    <span>
      <xsl:attribute name="id">
        <xsl:value-of select="@id"/>
      </xsl:attribute>
      <xsl:attribute name="ezdvCall">
        <xsl:value-of select="user:getDynamicText(string(@call),string($nameValuePairs),string(@xslt))"/>
      </xsl:attribute>
      <xsl:attribute name="ezdvInterval">
        <xsl:value-of select="@interval"/>
      </xsl:attribute>
      %%%<xsl:value-of select="user:getDynamicText(string(@call),string($nameValuePairs),string(@xslt))"/>%%%
      <xsl:apply-templates />
    </span>
  </xsl:if>
  <xsl:if test="not(@id)">
    <xsl:if test="@whitespace='none'">
      <xsl:variable name="val">
        %%%<xsl:value-of select="user:getDynamicText(string(@call),string($nameValuePairs),string(@xslt))"/>%%%
      </xsl:variable>
      <xsl:value-of select="normalize-space($val)"/>
    </xsl:if>
    <xsl:if test="not(@whitespace='none')">
      %%%<xsl:value-of select="user:getDynamicText(string(@call),string($nameValuePairs),string(@xslt))"/>%%%
    </xsl:if>
  </xsl:if>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="IF">
   <xsl:param name="nameValuePairs">
      <xsl:apply-templates select="PARAM" mode="dynamic"/>
      <xsl:apply-templates select="BIND" mode="dataBinding"/>
   </xsl:param>
   <xsl:param name="condition"><xsl:value-of select="@condition"/></xsl:param>
   <span>
      <xsl:call-template name="set_condition">
         <xsl:with-param name="id" select="@id"/>
         <xsl:with-param name="condition" select="$condition"/>
         <xsl:with-param name="nameValuePairs" select="$nameValuePairs"/>
      </xsl:call-template>
      <xsl:apply-templates />
   </span>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="LISTGRID">
   <xsl:if test="LISTGRIDHROW">
      <div>
         <xsl:attribute name="style">
            <xsl:text>WIDTH:</xsl:text>
            <xsl:value-of select="@width"/>
            <xsl:text>px;</xsl:text>
         </xsl:attribute>
         <xsl:apply-templates select="LISTGRIDHROW"/>
      </div>
   </xsl:if>
   <div>
      <xsl:attribute name="style">
         <xsl:text>WIDTH:</xsl:text>
         <xsl:value-of select="@width"/>
         <xsl:text>px;</xsl:text>
         <xsl:text>HEIGHT:</xsl:text>
         <xsl:value-of select="@height"/>
         <xsl:text>px;</xsl:text>
         <xsl:choose>
            <xsl:when test="LISTGRIDHROW">
               <xsl:text>border-top: 1px solid;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:attribute>
      <xsl:apply-templates select="LISTGRIDBROW"/>
      <xsl:apply-templates select="LISTGRIDBROW_NI"/>
   </div>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="LISTGRIDHROW">
   <div style="WIDTH: 100%;FONT-SIZE: 14px;font-weight:bold;COLOR: #777777">
      <span style="WIDTH:20px;"> <!-- leave room for radio button or checkbox -->
      </span>
      <xsl:apply-templates select="LISTGRIDHCOL"/>
   </div>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="LISTGRIDHCOL">
   <span>
      <xsl:attribute name="style">
         <xsl:text>WIDTH:</xsl:text>
         <xsl:value-of select="@width"/>
         <xsl:text>px;</xsl:text>
      </xsl:attribute>
      <xsl:apply-templates/>
   </span> 
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="LISTGRIDBROW">
   <xsl:param name="tag">
      <xsl:text>LISTGRIDBROW</xsl:text>
   </xsl:param>
   <xsl:param name="attr">
      <xsl:text>id%=%</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>%:%value%=%</xsl:text>
      <xsl:value-of select="user:XMLEncoding(string(@value))"/>
   </xsl:param>
   <div width="width: 100%">
      <xsl:call-template name="set_onclick">
         <xsl:with-param name="tag" select="$tag"/>
         <xsl:with-param name="attr" select="$attr"/>
      </xsl:call-template>
      <xsl:call-template name="set_ondblclick">
         <xsl:with-param name="tag" select="$tag"/>
         <xsl:with-param name="attr" select="$attr"/>
      </xsl:call-template>
      <label>
         <xsl:attribute name="for">
            <xsl:value-of select="@id"/>
         </xsl:attribute>
         <span style="CURSOR: default; width:20px;vertical-align: top">
            <input>
               <xsl:attribute name="name">
                  <xsl:value-of select="../@id"/>
               </xsl:attribute>
               <xsl:attribute name="ezdvValue">
                  <xsl:value-of select="@value"/>
               </xsl:attribute>
               <xsl:call-template name="set_checked"/>
               <xsl:attribute name="type">
                  <xsl:choose>
                     <xsl:when test="../@select='kSingle'">
                        <xsl:text>radio</xsl:text>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:text>checkbox</xsl:text>
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:attribute>
               <xsl:attribute name="id">
                  <xsl:value-of select="@id"/>
               </xsl:attribute>
            </input>
         </span>
         <xsl:apply-templates select="LISTGRIDBCOL"/>
      </label>
   </div>
</xsl:template>

<!-- ********************************************************************* -->
<!-- same as  LISTGRIDBROW, expect is doesn't create the input control -->
<xsl:template match="LISTGRIDBROW_NI">
   <xsl:param name="tag">
      <xsl:text>LISTGRIDBROW_NI</xsl:text>
   </xsl:param>
   <xsl:param name="attr">
      <xsl:text>id%=%</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>%:%value%=%</xsl:text>
      <xsl:value-of select="user:XMLEncoding(string(@value))"/>
   </xsl:param>
   <div width="width: 100%">
      <xsl:call-template name="set_onclick">
         <xsl:with-param name="tag" select="$tag"/>
         <xsl:with-param name="attr" select="$attr"/>
      </xsl:call-template>
      <xsl:call-template name="set_ondblclick">
         <xsl:with-param name="tag" select="$tag"/>
         <xsl:with-param name="attr" select="$attr"/>
      </xsl:call-template>
      <label>
         <xsl:attribute name="for">
            <xsl:value-of select="@id"/>
         </xsl:attribute>
         <span style="CURSOR: default; width:20px;vertical-align: top">
         </span>
         <xsl:apply-templates select="LISTGRIDBCOL"/>
      </label>
   </div>
</xsl:template>



<!-- ********************************************************************* -->
<xsl:template match="LISTGRIDBCOL">
   <xsl:param name="halign" select="@halign"/>   
   <xsl:param name="position" select="position()"/>
   <span>
      <xsl:attribute name="style">
         <xsl:text>HEIGHT:20px;</xsl:text>
         <xsl:text>WIDTH:</xsl:text>
         <xsl:choose>
            <xsl:when test="../../LISTGRIDHROW/LISTGRIDHCOL[position()=$position]/@width">
               <xsl:value-of select="../../LISTGRIDHROW/LISTGRIDHCOL[position()=$position]/@width"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="@width"/>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:text>px;</xsl:text>
         <xsl:text>CURSOR: default;</xsl:text>
         <xsl:text>vertical-align: top;</xsl:text>
         <xsl:if test="@halign">
            <xsl:text>text-align:</xsl:text>
            <xsl:value-of select="@halign"/>   
            <xsl:text>;</xsl:text>        
         </xsl:if>
      </xsl:attribute>
      <xsl:apply-templates/>
   </span>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="BIND" mode="dataBinding">
   <xsl:value-of select="@target"/>
   <xsl:choose>
   <xsl:when test="@sourcetype='kConst'">
      <xsl:text>%=%</xsl:text>
      <xsl:value-of select="@source"/>
      <xsl:text>%:%</xsl:text>
   </xsl:when>
   <xsl:otherwise>
      <xsl:text>%=%'+ezdv_getElementValue('</xsl:text>
      <xsl:value-of select="@source"/>
      <xsl:text>')+'%:%</xsl:text>
   </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="TRIGGER" mode="onchange">
   <xsl:text>zedvFireTrigger('</xsl:text>
   <xsl:value-of select="../@id"/>
   <xsl:text>');</xsl:text>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="HR.THICKLINE">
   <hr style="border: 3px solid  #BABABA;width: 100%;height: 6px;text-align: center;"/>
</xsl:template>

<xsl:template match="HR.DASHEDLINE">
   <hr style="border: 1px dashed  #BABABA;width: 100%;height: 1px;text-align: center;"/>
</xsl:template>

<!-- ********************************************************************* -->
  <xsl:template match="SCRIPT">
    <script>
      <xsl:attribute name="for">
        <xsl:value-of select="@id"/>
      </xsl:attribute>
      <xsl:attribute name="event">
        <xsl:value-of select="@event"/>
      </xsl:attribute>
      <xsl:apply-templates/>
    </script>
  </xsl:template>


  <!-- ******************************************************************************** -->
<!-- ******************************************************************************** -->
<!-- *************************  JavaScript functions ******************************** -->
<!-- ******************************************************************************** -->
<!-- ******************************************************************************** -->

<msxsl:script language="JavaScript" implements-prefix="user">
<![CDATA[

        function tweakEval(str, params)
        {
            var pList = (params) ? params : ""
            str =" "+str+" "
            str=str.replace(/(\W)and(\W)/ig,"$1&&$2")
            str=str.replace(/(\W)or(\W)/ig,"$1||$2")
            str=str.replace(/(\W)not(\W)/ig,"$1!$2")
            str=str.replace(/(\w+)\(\)/g,"ezdv_QueryHost('$1()','"+pList+"')")
            return str;
        }

        function getDynamicText(str,params,xsltTemplate)
        {
            var pList = (params) ? params : ""
            var xslt  = (xsltTemplate) ? ",'"+xsltTemplate+"'" : ""
            str=str.replace(/(.+)\(\)/g,"ezdv_QueryHost('$1()','"+pList+"'"+xslt+")")
            return str
        }

        function normalImage(str)
        {
           return str.replace(/\.gif/i,"_ne\.gif");
        }
        function hoverImage(str)
        {
           return str.replace(/\.gif/i,"_oe\.gif");
        }
        function downImage(str)
        {
           return str.replace(/\.gif/i,"_de\.gif");
        }
        function clickImage(str)
        {
           return str.replace(/\.gif/i,"_click\.gif");
        }
        function XMLEncoding(str)
        {
           str=str.replace(/'/g,"&#39;");
           return str;
        }
        function addTable(str)
        {
			return (str + "Table");
		}
		function addClick(str)
		{
			return (str + ".click()");
		}
]]>
</msxsl:script>



</xsl:stylesheet>




